<?php require_once("../db.php"); ?>
<?php 
require_once("encoding.php");


class Core2
{
    public $dbh; // handle of the db connexion
    private static $instance;

    private function __construct()
    {
        // building data source name from config
        $dsn = 'mysql:host=' . Config2::read('db.host') .
               ';dbname='    . Config2::read('db.basename') .
               ';port='      . Config2::read('db.port') .
               ';connect_timeout=15';
        // getting DB user from config                
        $user = Config2::read('db.user');
        // getting DB password from config                
        $password = Config2::read('db.password');

        $this->dbh = new PDO($dsn, $user, $password);
    }

    public static function getInstance()
    {
        if (!isset(self::$instance))
        {
            $object = __CLASS__;
            self::$instance = new $object;
        }
        return self::$instance;
    }

    // others global functions
}
class Config2
{
    static $confArray;

    public static function read($name)
    {
        return self::$confArray[$name];
    }

    public static function write($name, $value)
    {
        self::$confArray[$name] = $value;
    }

}

Config2::write('db.host', 'localhost');
Config2::write('db.port', '3306');
Config2::write('db.basename', 'hrchatma_import');
Config2::write('db.user', 'hrchatma_import');
Config2::write('db.password', '8k,qUryJ4WlB');



	/* first we have to get all numbers and:
		client_id = auto!
		client_number = newch.from
		ag = newch.ag
		client name = newch.ns
		client_date = newch.pl
		last_edited = newch.date_change
		description = newch.txt
	*/
	
	$core = Core::getInstance();
	$stmt = $core -> dbh -> prepare("TRUNCATE myclients");
	$stmt -> execute();
	
	$core = Core::getInstance();
	$stmt = $core -> dbh -> prepare("TRUNCATE messages");
	$stmt -> execute();
	
	
	
	try {
		$core = Core2::getInstance();
		$stmt = $core->dbh->prepare("SELECT * FROM newch ORDER BY id ASC");
		//$stmt = $core->dbh->prepare("SELECT * FROM newch WHERE id = 506 ORDER BY id ASC");
		$stmt -> execute();
		$results = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		
		foreach ($results as $key => $value) {
			$client_number = $value["from"];
			$ag = $value["ag"];
			$client_name = Encoding::toUTF8($value["ns"], Encoding::ICONV_TRANSLIT);
			$client_date = $value["pl"];
			$last_edited = $value["date_change"];
			$description = Encoding::toUTF8($value["txt"], Encoding::ICONV_TRANSLIT);
			
		
			
			$act = $value["act"];
			if ($act == "1") {
				// blokiran je
				$status = "0";
			} else {
				$status = "2";
			}
			
			// now import them!
			try {
				$core = Core::getInstance();
				$stmt = $core -> dbh -> prepare("INSERT INTO myclients (client_number, client_name, client_date, last_edited, description, status, ag) VALUES (:client_number, :client_name, :client_date, :last_edited, :description, :status, :ag)");
				$stmt -> bindParam("client_number", $client_number, PDO::PARAM_STR);
				$stmt -> bindParam("client_name", $client_name, PDO::PARAM_STR);
				$stmt -> bindParam("client_date", $client_date);
				$stmt -> bindParam("last_edited", $last_edited);
				$stmt -> bindParam("description", $description);
				$stmt -> bindParam("status", $status);
				$stmt -> bindParam("ag", $ag);
				$stmt -> execute();
				$client_id = $core->dbh->lastInsertId();
			} catch(PDOException $pe) {
				trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
			}
			
			
			
			// now fetch all messages related to that user and import them!!!
			try {
				$core = Core2::getInstance();
				$stmt = $core->dbh->prepare("SELECT * FROM tbl_chat WHERE user = :user or message_a like '%): ".$value["from"]."' ORDER BY date_post ASC");
				$stmt -> bindParam("user", $client_number);
				$stmt -> execute();
				$results_new = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			} catch(PDOException $pe) {
				trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
			}
			
			
			foreach($results_new as $key_new => $value_new) {
				$message = Encoding::toUTF8($value_new["message"], Encoding::ICONV_TRANSLIT);
				if (!preg_match('/^Agent/', $value_new["user"])) {
					$mess_whosent = "0";
					$mess_blk = "0";
					// treba unijeti odgovor od agenta!!!
					if ($value_new["message_a"] != "" && $value_new["date_send"] != "") {
						try {
							$core = Core::getInstance();
							$stmt = $core -> dbh -> prepare("INSERT INTO messages (mess_client_id, mess_message, mess_date, mess_whosent, mess_blk, mess_status) VALUES (:mess_client_id, :mess_message, :mess_date, '1', '0', '0')");
							$stmt -> bindParam("mess_client_id", $client_id, PDO::PARAM_INT);
							$stmt -> bindParam("mess_message", $value_new["message_a"], PDO::PARAM_STR);
							$stmt -> bindParam("mess_date", $value_new["date_send"]);
							$stmt -> execute();
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
					} else {
						echo("ne postoji odgovor".$value_new["chat_id"]."<br />");
					}
					
				} else {
					$mess_whosent = "1";
					$mess_blk = "1";
				}
				try {
					$core = Core::getInstance();
					$stmt = $core -> dbh -> prepare("INSERT INTO messages (mess_client_id, mess_message, mess_date, mess_whosent, mess_blk, mess_status) VALUES (:mess_client_id, :mess_message, :mess_date, :mess_whosent, :mess_blk, '0')");
					$stmt -> bindParam("mess_client_id", $client_id, PDO::PARAM_INT);
					$stmt -> bindParam("mess_message", $value_new["message"], PDO::PARAM_STR);
					$stmt -> bindParam("mess_date", $value_new["date_post"]);
					$stmt -> bindParam("mess_whosent", $mess_whosent);
					$stmt -> bindParam("mess_blk", $mess_blk);
					$stmt -> execute();
				} catch(PDOException $pe) {
					trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
				}
			}
		}
		
	} catch(PDOException $pe) {
		trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
	}
	
	/*
	$core = Core::getInstance();
	$stmt = $core -> dbh -> prepare("TRUNCATE messages");
	$stmt -> execute();
	
	try {
		$core = Core2::getInstance();
		$stmt = $core->dbh->prepare("SELECT * FROM tbl_chat ORDER BY id ASC");
		$stmt -> execute();
		$results = $stmt ->fetchAll(PDO::FETCH_ASSOC);
	} catch(PDOException $pe) {
		trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
	}*/
?>