$(document).ready(function() {
	$("#tbody_groupedMessages").on('click', 'tr th', function(param, callback) {
		$("#ul-mainChat").empty();
		var tbody_GM_ClientID = $(this).parent().data("id");
		getClientDetails(tbody_GM_ClientID);
		$("#inp_reply_clientID").val(tbody_GM_ClientID);
		$("#inp_rnd_clientID").val(tbody_GM_ClientID);
		getMainChat(tbody_GM_ClientID, true);
		$(this).parent().addClass('highlight').siblings().removeClass('highlight');
		$("#txt_bulk_send").val($(this).html());
		$('#blk_message').val('');
	});
	
	$("#tbody_groupedMessages").on('change', 'select.sel_status_css', function() {
		//alert($(this).data("id"));
		updateClientStatus($(this).data("id"), $(this).parents('tr').attr('id'));
		//alert($(this).parents('tr').attr('id'));
	});
});

$( 'select[name="sel_blk_option"]' ).change(function() {
	var sel_blk_option = $('select[name="sel_blk_option"] option:selected').val();
	if (sel_blk_option == "1") {
		$("#div_date_blk").hide();
		$("#div_blk_premium").hide();
		$("#div_by_number").show();
	} else {
		$("#div_date_blk").show();
		$("#div_blk_premium").show();
		$("#div_by_number").hide();
	}
});

$("#frm_search").submit(function() {
	var search_term = $.trim($("#txt_search_term").val());
	var sel_filter = $('select[name="sel_filter"] option:selected').val();
	if (search_term.length < 3 && search_term.length > 0) {
		alert("Molimo unesite najmanje 3 znaka");
	} else {
		// empty tbody!
		$("#tbody_groupedMessages, #ul-mainChat").empty();
		$("#div_main_chat_show_more").hide();
		
		$.getJSON( "ajax/search-analysis.php?ag="+current_ag+"&search_term="+search_term+"&search_filter="+sel_filter, function( data ) {
			$("#tbl_grouped_mess").trigger("destroy");
			if (data.length == 0) {
				alert("Nema rezultata");
				
			}
			$.each( data, function( key, val ) {
				var gcval = "gc_"+val.mess_client_id;
				var class_red = "";
				var tr_class = "";
				var aktiv_selected = "";
				var pauz_selected = "";
				var blok_selected = "";
				if (val.mess_whosent == "0") {
					var class_red = "nored";
				}
				if (val.status == "2") {
					var tr_class = "table-danger";
				} else if (val.status == "1") {
					var tr_class = "table-warning";
				}
				
				if (val.status == "1") {
					var pauz_selected = "selected";
				} else if (val.status == "2") {
					var blok_selected = "selected";
				} else {
					var aktiv_selected = "selected";
				}
				
				$("<tr class='"+tr_class+"' id='gc_"+val.mess_client_id+"' data-id='"+val.mess_client_id+"' data-date='"+val.js_mess_date+"'><th id='th_"+val.mess_client_id+"' scope='row' class='"+class_red+"'>"+val.client_number+"</th><td>"+val.all_messages+"</td><td>"+val.today_messages+"</td><td>"+val.yesterday_messages+"</td><td>"+val.last7days_messages+"</td><td>"+val.thismonth_messages+"</td><td>"+val.lastmonth_messages+"</td><td>"+val.ag+"</td><td><select id='client_ST"+val.mess_client_id+"' class='form-select sel_status_css' name='client_ST"+val.mess_client_id+"' data-id='"+val.mess_client_id+"'><option value='0' "+aktiv_selected+
				">Aktivan</option><option value='1' "+pauz_selected+">Pauziran</option><option value='2' "+blok_selected+">Blokiran</option></select></td></tr>").appendTo("#tbody_groupedMessages");
			});
			$("#tbl_grouped_mess").tablesorter();
		});
	}
	
	event.preventDefault();
	//alert(search_term);
});

$("#frm_rnd").on('click', '#btn_rnd', function () {
	$.ajax({
		'url':'ajax/input-rnd-send.php?ag='+current_ag,
		'type':'POST',
		'data': $("#frm_rnd").serialize(),
		'dataType':'json',
		'success':function(retData) { 
			// success
			if(retData.send == "false") {
				alert(retData.reason);
			}
		}, 
		'error':function(e) { 
			//failed 
			//alert("Failed");
		} 
	});
});

function sendCustomMessage() {
	$("#sp_blk_send").empty();
	if (!$.trim($("#txt_bulk_send").val())) {
		alert("Unesite broj");
	} else if (!$.trim($("#blk_message").val())) {
		alert("Unesite poruku");
	} else {
		$.ajax({
			'url':'ajax/input-custom-message.php?ag='+current_ag,
			'type':'POST',
			'data':$("#frm_bulk").serialize(),
			'dataType':'json',
			'success':function(retData) {
				if(retData.send == "false") {
				    $('#blk_message').val('');
					alert(retData.reason);
				} else if (retData.send == "true") {
					$("#sp_blk_send").html(retData.reason);
					$('#blk_message').val('');
				} else {
					alert(retData);
				}
			},
			'error':function(e) {
				alert("Failed sendCustomMessage");
			}
		});
	}
}

$('#btn_send_blk').on('click', function() {
	var selected_option = $('select[name=sel_blk_option] option:selected').val();
	if (selected_option == "0") {
		//perform blk send!
		sendBlk();
	} else {
		sendCustomMessage();
	}
});